import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import InterventoForm from "../../../../core/Forms/InterventoForm/InterventoForm";
import {authUserQuery,speciesProgettoQuery} from "../../../../api/queries";
import Loading from "../../../../core/Loading/Loading";

class Create extends Component {

  constructor(props) {
    super(props);

    this.state = {
      submitting: false,
      error: false,
    };
  }

  render() {

	 console.log('utenteSessione')
	  console.log(this.props.utenteSessione)

    if(this.props.data.loading) {
      return(<Loading/>);
    }

    return (
      <div className="container" style={{marginBottom: '20px'}}>
        <h1>Nuovo Intervento</h1>
        <InterventoForm
          errorMessage={"Errore durante la creazione dell'intervento"}
          data={this.props.data}
	  utenteSessione={this.props.utenteSessione}
          submitMutation={gql`
                    mutation($intervento: InterventoInput) {
                        updateIntervento(intervento: $intervento) {
                            id
                        }
                    }`} />
      </div>
    )
  }
}

export default compose(
  graphql(speciesProgettoQuery),
    graphql(authUserQuery, {name: 'utenteSessione'})
)(Create);

Create.defaultProps = {};

Create.propTypes = {};
